# Swift Syntax 601 Release Notes

## New APIs

- `SameTypeRequirementSyntax` has a new `RightType` nested type.
  - Description: The Swift parser can now parse values as types in certain situations, so the new type reflects the possibility of the argument being either an `ExprSyntax` or a `TypeSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2859

- `SameTypeRequirementSyntax` has a new `LeftType` nested type.
  - Description: The Swift parser can now parse values as types in certain situations, so the new type reflects the possibility of the argument being either an `ExprSyntax` or a `TypeSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2859

- `GenericArgumentSynax` has a new `Argument` nested type.
  - Description: The Swift parser can now parse values as types in certain situations, so the new type reflects the possibility of the argument being either an `ExprSyntax` or a `TypeSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2859

- `GenericParameterSyntax` now has a new `specifier` property.
  - Description: With the introduction of value generics, generic parameters can now be optionally preceded by either a `let` or an `each`. The `specifier` property captures the token representing which one was parsed.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2785

- `IntegerLiteralExprSyntax` and `FloatLiteralExprSyntax` now have a computed `representedLiteralValue` property.
  - Description: Allows retrieving the represented literal value when valid.
  - Issue: https://github.com/apple/swift-syntax/issues/405
  - Pull Request: https://github.com/apple/swift-syntax/pull/2605
    
- `SyntaxProtocol` now has a method `ancestorOrSelf`.
  - Description: Returns the node or the first ancestor that satisfies `condition`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2696

- `Error` protocol now has an `asDiagnostics(at:)` method.
  - Description: This method translates an error into one or more diagnostics, recognizing `DiagnosticsError` and `DiagnosticMessage` instances or providing its own `Diagnostic` as needed.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/1816

- Added a new library `SwiftIfConfig`.
  - Description: This new library provides facilities for evaluating `#if` conditions and determining which regions of a syntax tree are active according to a given build configuration.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/1816
  
- `SwiftBasicFormat` adds a method `indented(by:)` to all syntax node types.
  - Description: This method indents a node’s contents using a provided piece of `Trivia`, optionally including the first line.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2843

- `Parser.ExperimentalFeatures` has a new `init?(name: String)` initializer.
  - Description: This initializer returns the `Parser.ExperimentalFeatures` value that matches the experimental parser feature with the given name. The name must be spelled the same way as it is when passed to the compiler using the `-enable-experimental-feature` flag.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2895

## API Behavior Changes

- `SyntaxProtocol.trimmed` detaches the node
  - Description: Getting a trimmed version of a node detaches it from its parent. Having the trimmed node be attached to a parent was not intuitive because eg. printing the parent node would have the trimmed trivia missing, most likely forming invalid Swift code.
  - Pull Request: https://github.com/apple/swift-syntax/pull/2689

## Deprecations

- `GenericParameterSyntax` deprecated `eachKeyword` in favor of `specifier`
  - Description: `specifier` is now used to grab either the `each` keyword for a generic parameter or the `let` keyword.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2785

- `IncrementalEdit` deprecated in favor of `SourceEdit`
  - Description: `IncrementalEdit` is being dropped for `SourceEdit`. `SourceEdit` has deprecated compatibility layers to make it API-compatible with `IncrementalEdit`
  - Issue: https://github.com/apple/swift-syntax/issues/2532
  - Pull request: https://github.com/apple/swift-syntax/pull/2604
  
- `ClosureCaptureSyntax.init(leadingTrivia:specifier:name:equal:expression:trailingComma:trailingTrivia:)` deprecated in favor of a new `ClosureCaptureSyntax.init(leadingTrivia:_:specifier:_:name:_:initializer:_:trailingComma:_:trailingTrivia:)` initializer.
  - Description: `ClosureCaptureSyntax` now has an `initializer` property instead of `equal` and `expression`. Additionally, the `name` property is no longer optional.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2763 

- `Indenter` in `SwiftSyntaxBuilder` has been deprecated in favor of the new `indented(by:)` in `SwiftBasicFormat`.
  - Description: Indenting is really more of a formatting operation than a syntax-building operation. Additionally, the `indented(by:)` method is more intuitive to use than a `SyntaxRewriter`. Aside from `BasicFormat`, there are no other public `SyntaxRewriter` classes in the package.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2843

## API-Incompatible Changes

- `SameTypeRequirementSyntax.rightType` has changed types from `TypeSyntax` to `SameTypeRequirementSyntax.RightType`
  - Description: The Swift parser can now parse values as types in certain situations, so the new type reflects the possibility of the argument being either an `ExprSyntax` or a `TypeSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2859

- `SameTypeRequirementSyntax.leftType` has changed types from `TypeSyntax` to `SameTypeRequirementSyntax.LeftType`
  - Description: The Swift parser can now parse values as types in certain situations, so the new type reflects the possibility of the argument being either an `ExprSyntax` or a `TypeSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2859

- `GenericArgumentSyntax.argument` has changed types from `TypeSyntax` to `GenericArgumentSyntax.Argument`
  - Description: The Swift parser can now parse values as types in certain situations, so the new type reflects the possibility of the argument being either an `ExprSyntax` or a `TypeSyntax`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2859

- Moved `Radix` and `IntegerLiteralExprSyntax.radix` from `SwiftRefactor` to `SwiftSyntax`.
  - Description: Allows retrieving the radix value from the `literal.text`.
  - Issue: https://github.com/apple/swift-syntax/issues/405
  - Pull Request: https://github.com/apple/swift-syntax/pull/2605

- `FixIt.Change` gained a new case `replaceChild(data:)`.
  - Description: The new case covers the replacement of a child node with another node.
  - Issue: https://github.com/swiftlang/swift-syntax/issues/2205
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2758
  - Migration steps: In exhaustive switches over `FixIt.Change`, cover the new case.

- `ClosureCaptureSyntax.name` is no longer optional.
  - Description: Due to the new `ClosureCaptureSyntax` node structure, `name` property is non-optional.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/2763 

## Template

- *Affected API or two word description*
  - Description: *A 1-2 sentence description of the new/modified API*
  - Issue: *If an issue exists for this change, a link to the issue*
  - Pull Request: *Link to the pull request(s) that introduces this change*
  - Migration steps: Steps that adopters of swift-syntax should take to move to the new API (required for deprecations and API-incompatible changes).
  - Notes: *In case of deprecations or API-incompatible changes, the reason why this change was made and the suggested alternative*

*Insert entries in chronological order, with newer entries at the bottom*
